//
//  SwipesViewController.m
//  Swipes
//
//  Created by Robert Górczyński on 11-07-25.
//

#import "SwipesViewController.h"

#define kMinimumGestureLength    25 
#define kMaximumVariance         5 


@implementation SwipesViewController
@synthesize label; 
@synthesize gestureStartPoint; 

- (void)eraseText { 
    label.text = @""; 
} 


// Implementacja metody viewDidLoad pozwala na przeprowadzenie konfiguracji po wczytaniu widoku, zazwyczaj z pliku nib.
- (void)viewDidLoad {
    [super viewDidLoad];
    UISwipeGestureRecognizer *vertical; 
	
    for (NSUInteger touchCount = 1; touchCount <= 5; touchCount++) { 
        vertical = [[[UISwipeGestureRecognizer alloc] initWithTarget:self 
															  action:@selector(reportVerticalSwipe:)] autorelease]; 
        vertical.direction = UISwipeGestureRecognizerDirectionUp|  
		UISwipeGestureRecognizerDirectionDown; 
        vertical.numberOfTouchesRequired = touchCount; 
        [self.view addGestureRecognizer:vertical]; 
		
        UISwipeGestureRecognizer *horizontal; 
        horizontal = [[[UISwipeGestureRecognizer alloc] initWithTarget:self 
																action:@selector(reportHorizontalSwipe:)] autorelease]; 
        horizontal.direction = UISwipeGestureRecognizerDirectionLeft|  
		UISwipeGestureRecognizerDirectionRight; 
        horizontal.numberOfTouchesRequired = touchCount; 
        [self.view addGestureRecognizer:horizontal]; 
    }  	
}

- (void)didReceiveMemoryWarning {
	// Jeżeli widok nie posiada widoku nadrzędnego, wówczas zostanie usunięty z pamięci.
    [super didReceiveMemoryWarning];
	
	// Usunięcie z pamięci wszelkich buforowanych danych, obrazów i innych zasobów, które obecnie nie są używane.
}

- (void)viewDidUnload {
	/// Usunięcie wszystkich „przytrzymanych” podwidoków widoku głównego,
    // na przykład self.myOutlet = nil;
    self.label = nil; 
    [super viewDidUnload]; 
}


- (void)dealloc {
    [label release]; 
    [super dealloc];
}

- (NSString *)descriptionForTouchCount:(NSUInteger)touchCount { 
    if (touchCount == 2) 
        return @"podwójne"; 
    else if (touchCount == 3) 
        return @"potrójne"; 
    else if (touchCount == 4) 
        return @"poczwórne"; 
    else if (touchCount == 5) 
        return @"pięcikrotne"; 
    else 
        return @""; 
}

#pragma mark - 
- (void)reportHorizontalSwipe:(UIGestureRecognizer *)recognizer { 
	label.text = [NSString stringWithFormat:@"Wykryto %@ machnięcie poziome", 
				  [self descriptionForTouchCount:[recognizer numberOfTouches]]];  
	[self performSelector:@selector(eraseText) withObject:nil afterDelay:2]; 
} 

- (void)reportVerticalSwipe:(UIGestureRecognizer *)recognizer { 
	label.text = [NSString stringWithFormat:@"Wykryto %@ machnięcie pionowe",
				  [self descriptionForTouchCount:[recognizer numberOfTouches]]]; 
	[self performSelector:@selector(eraseText) withObject:nil afterDelay:2]; 
}


@end
